# Firestore Import Export
A script that help to export and import in Cloud Firestore

** This repo is not maintained. Please try the [backup and restore from Firestore](https://github.com/dalenguyen/firestore-backup-restore) package instead!

# Requirements

You need [NODE](https://nodejs.org/en/download/) or something that can run JAVASCRIPT (JS) file.

Get **serviceAccount** JSON file from *Project Setting > SERVICE ACCOUNTS* in Firebase Console

Change the *databaseURL* when initializeApp with your own

# Setting Up

Download or clone this repository

```
git clone https://github.com/dalenguyen/firestore-import-export.git
```

Install NPM packages

```
npm install
```

# Export database from Firestore

This will help you create a backup of your collection and subcollection from Firestore to a JSON file name **firestore-export.json**

```
node export.js <your-collection-name> <sub-collection-name-(optional)>
```

# Import database to Firestore

This will import a collection to Firestore will overwrite any documents in that collection with matching id's to those in your json. If you have date type in your JSON, please add the field to the command line. **The date and geo arguments is optional**. 

```
node import.js import-to-firestore.json date=date geo=Location
```

If you have date type in your JSON, please add to your command line 

Sample from __import-to-firestore.json__. "test" will be the collection name. The date type will have _seconds and _nanoseconds in it.

```
{
  "test" : {
    "first-key" : {
      "email"   : "dungnq@itbox4vn.com",
      "website" : "dalenguyen.me",
      "custom"  : {
        "firstName" : "Dale",
        "lastName"  : "Nguyen"
      },
      "date": {
        "_seconds":1534046400,
        "_nanoseconds":0
      },
      "Location": {
        "_latitude": 49.290683,
        "_longitude": -123.133956
      }
    },
    "second-key" : {
      "email"   : "test@dalenguyen.me",
      "website" : "google.com",
      "custom"  : {
        "firstName" : "Harry",
        "lastName"  : "Potter"
      },
      "date": {
        "_seconds":1534262435,
        "_nanoseconds":0
      },
      "Location": {
        "_latitude": 49.290683,
        "_longitude": -123.133956
      }
    }
  }
}
```

# Change serviceAccountKey.json 

	(You can get from firbase account Project settings ->Service account -> Select Node.js -> Generate new private key see:https://prnt.sc/5YcwVJHM5Pcb )

# IMPORT Commands:

node import.js eMartDataSeed/SOS.json
node import.js eMartDataSeed/banner_items.json
node import.js eMartDataSeed/booked_table.json
node import.js eMartDataSeed/brands.json
node import.js eMartDataSeed/car_make.json
node import.js eMartDataSeed/car_model.json
node import.js eMartDataSeed/channel_participation.json
node import.js eMartDataSeed/channels.json
node import.js eMartDataSeed/cms_pages.json
node import.js eMartDataSeed/complaints.json
node import.js eMartDataSeed/coupons.json
node import.js eMartDataSeed/currencies.json
node import.js eMartDataSeed/driver_payouts.json
node import.js eMartDataSeed/favorite_item.json
node import.js eMartDataSeed/favorite_vendor.json
node import.js eMartDataSeed/items_review.json
node import.js eMartDataSeed/notifications.json
node import.js eMartDataSeed/order_transactions.json
node import.js eMartDataSeed/parcel_categories.json
node import.js eMartDataSeed/parcel_coupons.json
node import.js eMartDataSeed/parcel_orders.json
node import.js eMartDataSeed/parcel_weight.json
node import.js eMartDataSeed/payouts.json
node import.js eMartDataSeed/promos.json
node import.js eMartDataSeed/rating.json
node import.js eMartDataSeed/rental_coupons.json
node import.js eMartDataSeed/rental_orders.json
node import.js eMartDataSeed/rental_vehicle_type.json
node import.js eMartDataSeed/reports.json
node import.js eMartDataSeed/review_attributes.json
node import.js eMartDataSeed/rides.json
node import.js eMartDataSeed/sections.json
node import.js eMartDataSeed/services.json
node import.js eMartDataSeed/settings.json
node import.js eMartDataSeed/users.json
node import.js eMartDataSeed/vehicle_type.json
node import.js eMartDataSeed/vendor_attributes.json
node import.js eMartDataSeed/vendor_categories.json
node import.js eMartDataSeed/vendor_orders.json
node import.js eMartDataSeed/vendor_products.json
node import.js eMartDataSeed/vendors.json
node import.js eMartDataSeed/wallet.json

# Export commands:

node export.js SOS
node export.js banner_items
node export.js booked_table
node export.js brands
node export.js car_make
node export.js car_model
node export.js channel_participation
node export.js channels
node export.js cms_pages
node export.js complaints
node export.js coupons
node export.js currencies
node export.js driver_payouts
node export.js favorite_item
node export.js favorite_vendor
node export.js items_review
node export.js notifications
node export.js order_transactions
node export.js parcel_categories
node export.js parcel_coupons
node export.js parcel_orders
node export.js parcel_weight
node export.js payouts
node export.js promos
node export.js rating
node export.js rental_coupons
node export.js rental_orders
node export.js rental_vehicle_type
node export.js reports
node export.js review_attributes
node export.js rides
node export.js sections
node export.js services
node export.js settings
node export.js users
node export.js vehicle_type
node export.js vendor_attributes
node export.js vendor_categories
node export.js vendor_orders
node export.js vendor_products
node export.js vendors
node export.js wallet