<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.order_plural')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href= "<?php echo route('categories'); ?>" ><?php echo e(trans('lang.order_plural')); ?></a></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	   <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
            <div class="row">
        <div class="col-6">
          <div class="form-group row">
          <label class="col-4 control-label"><?php echo e(trans('lang.order_id')); ?></label>
          <input type="text" class=" col-7 form-control order_id" disabled>
        </div>
      <div class="form-group row">
        <label class="col-4 control-label"><?php echo e(trans('lang.order_user_id')); ?></label>
        <input type="text" class=" col-7 form-control client_name" disabled>

      </div>
      <div class="form-group row">
        <label class="col-4 control-label"><?php echo e(trans('lang.restaurant')); ?></label>
        <input type="text" class=" col-7 form-control order_restaurant" disabled>

      </div>
      <div class="form-group row">
        <label class="col-4 control-label"><?php echo e(trans('lang.order_order_status_id')); ?></label>
          <select id= "order_status" class="col-7 form-control">
            <option value="Order Placed"><?php echo e(trans('lang.order_placed')); ?></option>
            <option value="Order Accepted"><?php echo e(trans('lang.order_accepted')); ?></option>
            <option value="Order Rejected"><?php echo e(trans('lang.order_rejected')); ?></option>
            <option value="Driver Pending"><?php echo e(trans('lang.driver_pending')); ?></option>
            <option value="Driver Rejected"><?php echo e(trans('lang.driver_rejected')); ?></option>
            <option value="Order Shipped"><?php echo e(trans('lang.order_shipped')); ?></option>
            <option value="In Transit"><?php echo e(trans('lang.in_transit')); ?></option>
            <option value="Order Completed"><?php echo e(trans('lang.order_completed')); ?></option>            
          </select>      
      </div>

    </div>
    <div class="col-6">
        <div class="form-group row">
          <label class="col-4 control-label"><?php echo e(trans('lang.restaurants_payout_amount')); ?></label>
          <input type="text" class=" col-7 form-control order_price" disabled>
        </div>
              <div class="row">
        <div class="col-6">
          <div class="form-group row">
            <label class="col-12 control-label"><?php echo e(trans('lang.product')); ?></label>
            <div id="order_products_list"></div>
          </div>
        </div>
        <div class="col-6">
          <div class="form-group row">
            <label class="col-12 control-label"><?php echo e(trans('lang.quantity')); ?></label>
            <div id="order_products_quantity"></div>
          </div>
        </div>
    </div>

      </div>
    </div>
      </div>

                  <div class="form-group col-12 text-right">
          <button type="button" class="btn btn-primary save_order_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
          <a href="<?php echo route('orders'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
      </div>

          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
var id = "<?php echo $id;?>";
var database = firebase.firestore();
var ref = database.collection('restaurant_orders').where("id","==",id);
$(document).ready(function(){
    jQuery("#data-table_processing").show();
    ref.get().then( async function(snapshots){
    var order = snapshots.docs[0].data();
  console.log(order);
    $(".order_id").val(order.id);
    $(".client_name").val(order.author.firstName+' '+order.author.lastName);
    $("#order_status option[value='"+order.status+"']").attr("selected","selected");
    var price = 0;
    order.products.forEach((product)=>{
        $("#order_products_list").append('<input type="text" class="form-control col-12" value="'+product.name+'" disabled>');
        $("#order_products_quantity").append('<input type="number" class="form-control col-12" value="'+product.quantity+'" disabled>');
        if(product.price && product.quantity != 0){
            var productTotal = parseInt(product.price)*parseInt(product.quantity);
            price = price + productTotal;
        }
    })

    $(".order_price").val(price);
    $("#order_status").val(order.status);
    $(".order_restaurant").val(order.vendor.title);
 
       jQuery("#data-table_processing").hide();
  })


$(".save_order_btn").click(function(){

  var clientName = $(".client_name").val();
  var orderStatus = $("#order_status").val();

    database.collection('restaurant_orders').doc(id).update({'status':orderStatus}).then(function(result) {        
        window.location.href = '<?php echo e(route("orders")); ?>';
    }); 
   
})

})
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/orders/edit.blade.php ENDPATH**/ ?>