<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.currency_edit')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href= "<?php echo route('currencies'); ?>" ><?php echo e(trans('lang.currency_table')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.currency_edit')); ?></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	   <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
            <div class="row">
          <div class="col-md-6">
              <div class="form-group row">
                <label class="col-5 control-label"><?php echo e(trans('lang.currency_name')); ?></label>
                <input type="text" class=" col-7 form-control currency_name">
              </div>
              
              <div class="form-group row">
                <label class="col-5 control-label"><?php echo e(trans('lang.currency_code')); ?></label>
                <input type="text" class=" col-7 form-control currency_code">
              </div>

               <div class="form-check">
                <input type="checkbox" class=" ml-2 form-check-inline symbol_at_right" id="symbol_at_right">
                <label class="col-5 control-label" for="symbol_at_right"><?php echo e(trans('lang.symbole_at_right')); ?></label>
                
              </div>
            </div>
            <div class="col-6">
                <div class="form-group row">
                <label class="col-5 control-label"><?php echo e(trans('lang.currency_symbol')); ?></label>
                <input type="text" class=" col-7 form-control currency_symbol">
              </div>
              
              <div class="form-check">
                <input type="checkbox" class=" ml-2 form-check-inline currency_active" id="currency_active">
              <label class="col-3 control-label" for="currency_active"><?php echo e(trans('lang.active')); ?></label>
              
            </div>
              
            </div>


                  <div class="form-group col-12 text-right">
          <button type="button" class="btn btn-primary save_currency_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
          <a href="<?php echo route('categories'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
      </div>

          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
var id = "<?php echo $id;?>";

var database = firebase.firestore();
var ref = database.collection('currencies').where('id','==',id);

$(document).ready(function(){
  jQuery("#data-table_processing").show();
  ref.get().then( async function(snapshots){
  var currency = snapshots.docs[0].data();

  $(".currency_name").val(currency.name);
  $(".currency_code").val(currency.code);
  $(".currency_symbol").val(currency.symbol);

  if(currency.isActive){
      $(".currency_active").prop('checked',true);
  }

  if(currency.symbolAtRight){
      $(".symbol_at_right").prop('checked',true);
  }

  jQuery("#data-table_processing").hide();
}); 
    

    $(".save_currency_btn").click(function(){
 
      var currencyName = $(".currency_name").val();
      var currencyCode = $(".currency_code").val();
      var currencySymbol = $(".currency_symbol").val();
      var active = $(".currency_active").is(":checked");
      var symbolAtRight = $(".symbol_at_right").is(":checked");

         if(active){

            database.collection('currencies').where('isActive',"==",true).get().then(function(snapshots) {
                    
                    var activeCurrency = snapshots.docs[0].data();
                    var activeCurrencyId = activeCurrency.id;

                    database.collection('currencies').doc(activeCurrencyId).update({'isActive':false});
             });
        }

        database.collection('currencies').doc(id).update({'name':currencyName,'code':currencyCode,'symbol':currencySymbol,'isActive':active,'symbolAtRight':symbolAtRight}).then(function(result) {
                window.location.href = '<?php echo e(route("currencies")); ?>';  
        });
     
    })
    
});


  

  </script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/settings/currencies/edit.blade.php ENDPATH**/ ?>