<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="row page-titles">

            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor"><?php echo e(trans('lang.special_offer')); ?></h3>
            </div>
            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(trans('lang.special_offer')); ?></li>
                </ol>
            </div>
        </div>

        <div class="card-body">
            <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">
                Processing...
            </div>
            <div class="row vendor_payout_create">
                <div class="vendor_payout_create-inner">
                    <fieldset>
                        <legend><?php echo e(trans('lang.special_offer')); ?></legend>

                        <div class="form-check width-100">
                            <input type="checkbox" class="form-check-inline" id="enable_special_discount">
                            <label class="col-5 control-label"
                                   for="enable_special_discount"><?php echo e(trans('lang.enable_special_discount_offer')); ?></label>
                        </div>

                    </fieldset>
                </div>
            </div>

            <div class="form-group col-12 text-center">
                <button type="button" class="btn btn-primary save_special_offer"><i
                            class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i
                            class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
            </div>
        </div>


        <?php $__env->stopSection(); ?>

        <?php $__env->startSection('scripts'); ?>

            <script>

                var database = firebase.firestore();
                var ref = database.collection('settings').doc("specialDiscountOffer");

                var photo = "";
                $(document).ready(function () {

                    jQuery("#data-table_processing").show();
                    ref.get().then(async function (snapshots) {
                        var specialDiscountOffer = snapshots.data();
                       
                        if (specialDiscountOffer == undefined) {
                            database.collection('settings').doc('specialDiscountOffer').set({});
                        }
                        try {
                            if (specialDiscountOffer.isEnable) {
                                $("#enable_special_discount").prop('checked', true);

                            }

                        } catch (error) {

                        }

                        jQuery("#data-table_processing").hide();

                    })

                    $(".save_special_offer").click(function () {

                        var is_disable_delete = "<?php echo env('IS_DISABLE_DELETE', 0); ?>";

                        if (is_disable_delete == 1) {
                            alert("Do not alllow to change in demo content !");
                            return false;
                        }
                        var checkboxValue = $("#enable_special_discount").is(":checked");

                        database.collection('settings').doc("specialDiscountOffer").update({'isEnable': checkboxValue}).then(function (result) {
                            window.location.href = '<?php echo e(url("settings/app/specialOffer")); ?>';
                        });

                    })
                })
            </script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/settings/app/specialDiscountOffer.blade.php ENDPATH**/ ?>