<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor"><?php echo e(trans('lang.footer_template')); ?></h3>
            </div>

            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(trans('lang.footer_template')); ?></li>
                </ol>
            </div>
            <div>


            </div>

        </div>

        <div class="card-body">

            <div id="data-table_processing" class="dataTables_processing panel panel-default"
                 style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
            <div class="error_top"></div>

            <div class="row vendor_payout_create">
                <div class="vendor_payout_create-inner">
                    <fieldset>
                        <legend><?php echo e(trans('lang.footer_template')); ?></legend>

                        <div class="form-group width-100">
                            <textarea class="form-control col-7" name="footerTemplate" id="footerTemplate"></textarea>
                        </div>


                    </fieldset>

                </div>
            </div>
        </div>

        <div class="form-group col-12 text-center btm-btn">
            <button type="button" class="btn btn-primary  create_footer_btn"><i
                        class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
            <a href="<?php echo route('users'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?>

            </a>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>

        var database = firebase.firestore();
        var photo = "";
        var ref = database.collection('settings').doc('footerTemplate');
        $(document).ready(function () {
            try {
                jQuery("#data-table_processing").show();
                ref.get().then(async function (snapshots) {
                    var footerTemplateData = snapshots.data();

                    if (footerTemplateData == undefined) {
                        database.collection('settings').doc('footerTemplate').set({"footerTemplate": ""});
                    }
                    console.log(footerTemplateData.footerTemplate);
                    if (footerTemplateData.footerTemplate != undefined) {
                        $('#footerTemplate').summernote("code", footerTemplateData.footerTemplate);
                    }
                });
            } catch (error) {

            }

            jQuery("#data-table_processing").hide();

            $('#footerTemplate').summernote({
                height: 400,
                width: 1024,
                toolbar: [
                    // [groupName, [list of button]]
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['forecolor', ['forecolor']],
                    ['backcolor', ['backcolor']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']],
                    ['view', ['fullscreen', 'codeview', 'help']],
                ]
            });
            $(".create_footer_btn").click(function () {

                var footerTemplate = $('#footerTemplate').summernote('code');

                if (footerTemplate == '') {
                    $(".error_top").show();
                    $(".error_top").html("");
                    $(".error_top").append("<p><?php echo e(trans('lang.footer_template_error')); ?></p>");
                    window.scrollTo(0, 0);

                } else {

                    database.collection('settings').doc('footerTemplate').update({'footerTemplate': footerTemplate}).then(function (result) {
                        window.location.href = '<?php echo e(route("footerTemplate")); ?>';
                    })

                }
            })
        });


    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/footerTemplate/index.blade.php ENDPATH**/ ?>