<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.restaurant_filter')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                  <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item">
                  <a href="<?php echo e(url('/restaurantFilters')); ?>"><?php echo e(trans('lang.restaurant_filter')); ?></a>
                </li>
                <li class="breadcrumb-item"><?php echo e(trans('lang.restaurant_filter_edit')); ?></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	   <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
           <div class="row">
        <div class="col-6">

          <div class="form-group row">
              <label class="col-3 control-label"><?php echo e(trans('lang.restaurant_filter_name')); ?></label>
              <input type="text" class="col-9 form-control filter_name">
          </div>

          <div class="form-group row">
              <label class="col-3 control-label"><?php echo e(trans('lang.add_new_option')); ?></label>
              <input type="text" class=" col-9 form-control add_option_name">&nbsp;&nbsp;
              <button type="button" class="btn btn-primary add_option_btn"><?php echo e(trans('lang.add_option')); ?></button>
          </div>
          <label class="col-3 control-label"><?php echo e(trans('lang.restaurant_filter_options')); ?></label>
          <div class="form-group row filter_options col-9">
           <!-- <input type="text" class="form-control filter_options"> -->
          </div>

        </div>

        <div class="col-6">          
          
        </div>
      </div>
  
      </div>

          <div class="form-group col-12 text-right">
            <button type="button" class="btn btn-primary save_filter_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
            <a href="<?php echo route('restaurantFilters'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
          </div>

          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
      
  var id = "<?php echo $id;?>";
var database = firebase.firestore();
var ref = database.collection('vendor_filters').where("id","==",id);


$(document).ready(function(){
  jQuery("#data-table_processing").show();
  ref.get().then( async function(snapshots){
  var filter = snapshots.docs[0].data();




  $(".filter_name").val(filter.name);
        

  filter.options.forEach((option)=>{
      $(".filter_options").append('<input checked type="checkbox" name="action" id="track" value="'+option+'" /><label for="track">'+option+'</label><br />&nbsp;&nbsp');
  })

            
  jQuery("#data-table_processing").hide();

  })


  
  $(".save_filter_btn").click(function(){
      //var photo ="https://assets.bonappetit.com/photos/5d03bea59ffc67bff3c6f86e/master/pass/HLY_Lentil_Burger_Horizontal.jpg";
      var filterName = $(".filter_name").val();
      var RButtons = [];
      $("input:checkbox[name=action]:checked").each(function(){
        RButtons.push($(this).val());
      });

      alert("This is for demo, We can't allow to edit");
      /* database.collection("vendor_filters").doc(id).update({'name':filterName,'options':RButtons}).then(function(result){

       window.location.href = '<?php echo e(url()->current()); ?>';
      }) */
       
    })

  $(".add_option_btn").click(function(){
    var optionname = $(".add_option_name").val();
    if(optionname != ''){
      $(".filter_options").append('<input checked type="checkbox" name="action" id="track" value="'+optionname+'" /><label for="track">'+optionname+'</label><br />&nbsp');
    }

    
  })


})


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/restaurant_filters/edit.blade.php ENDPATH**/ ?>