<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.radios_configuration')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.radios_configuration')); ?></li>
            </ol>
        </div>
    </div>

      <div class="card-body">
         <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
        <div class="row restaurant_payout_create">
          <div class="restaurant_payout_create-inner">
              <fieldset>
                <legend><?php echo e(trans('lang.radios_configuration')); ?></legend>
                <div class="form-group row width-50">
                    <label class="col-4 control-label"><?php echo e(trans('lang.restaurantnearby_radios')); ?></label>
                    <div class="col-7">
                      <div class="control-inner">
                        <input type="number" class="form-control restaurant_near_by" required>
                        <span><?php echo e(trans('lang.miles')); ?></span>
                      </div>
                    </div>
                  </div>
                <div class="form-group row width-50">
                    <label class="col-4 control-label"><?php echo e(trans('lang.driver_nearby_radios')); ?></label>
                    <div class="col-7">
                      <div class="control-inner">
                        <input type="number" class="form-control driver_nearby_radios" required>
                        <span><?php echo e(trans('lang.miles')); ?></span>
                    </div>
                    </div>
                </div>
              </fieldset>
          </div>
        </div>
      </div>
          <div class="form-group col-12 text-center btm-btn">
            <button type="button" class="btn btn-primary restaurant_near_by_save_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
            <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    


    var database = firebase.firestore();
    var ref = database.collection('settings').doc("RestaurantNearBy");
    var refDriver = database.collection('settings').doc("DriverNearBy");



    $(document).ready(function(){

        jQuery("#data-table_processing").show();
        ref.get().then( async function(snapshots){  
          var radios = snapshots.data();
          $(".restaurant_near_by").val(radios.radios);
        })

        refDriver.get().then( async function(snapshots){  
          var radios = snapshots.data();
          $(".driver_nearby_radios").val(radios.driverRadios);
        })
          jQuery("#data-table_processing").hide();
    })


      $(".restaurant_near_by_save_btn").click(function(){
        var restaurantNearBy = $(".restaurant_near_by").val();
        var driverNearBy = $(".driver_nearby_radios").val();
        if(restaurantNearBy == ''){
          alert("Please enter Restaurant nearby radios");
        }else if(driverNearBy == ''){
            alert("Please enter Driver radios");
        }else{
         database.collection('settings').doc("RestaurantNearBy").update({'radios':restaurantNearBy}).then(function(result) {

              database.collection('settings').doc("DriverNearBy").update({'driverRadios':driverNearBy}).then(function(result) {
                     window.location.href = '<?php echo e(url()->current()); ?>';         
              });

        });
        }
        
    })

</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/resources/views/settings/app/restaurantNearBy.blade.php ENDPATH**/ ?>