<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.restaurants_payout_plural')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><?php echo e(trans('lang.restaurants_payout_create')); ?></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	   <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
           <div class="row">
        <div class="col-6">
          <div class="form-group row">
            <label class="col-4 control-label"><?php echo e(trans('lang.restaurants_payout_restaurant_id')); ?></label>
            <div class="col-7">
              <select id="select_restaurant" class="form-control">
                <option value=""><?php echo e(trans('lang.select_restaurant')); ?></option>
              </select>
              <div class="form-text text-muted">
                <?php echo e(trans("lang.restaurants_payout_restaurant_id_help")); ?>

              </div>
            </div>
          </div>
          <div class="form-group row">
           <label class="col-4 control-label"><?php echo e(trans('lang.restaurants_payout_amount')); ?></label>
           <div class="col-7">
              <input type="number" class="form-control payout_amount">          
              <div class="form-text text-muted">
                <?php echo e(trans("lang.restaurants_payout_amount_placeholder")); ?>

              </div>
           </div>
          </div>

        </div>
        <div class="col-6">
          <div class="form-group row">
            <label class="col-2 control-label"><?php echo e(trans('lang.restaurants_payout_note')); ?></label>
            <div class="col-9">
              <textarea type="text" rows="7" class="form-control form-control payout_note"></textarea>
              
            </div>
          </div>
          
        </div>
      </div>
  
      </div>

          <div class="form-group col-12 text-right">
              <button type="button" class="btn btn-primary save_restaurant_payout_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
              <a href="<?php echo route('restaurantsPayouts'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
          </div>

          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
      
    var database = firebase.firestore();

  async function remainingPrice(vendorID){
  var paid_price = 0;
  var total_price = 0;
  var remaining = 0;
  await database.collection('payouts').where('vendorID','==',vendorID).get().then( async function(payoutSnapshots){        
       payoutSnapshots.docs.forEach((payout)=>{
          var payoutData = payout.data();
          paid_price = parseFloat(paid_price) + parseFloat(payoutData.amount);
        })

        await database.collection('restaurant_orders').where('vendor.id','==',vendorID).where("status","in",["Order Completed"]).get().then( async function(orderSnapshots){

            orderSnapshots.docs.forEach((order)=>{
              var orderData = order.data();
              orderData.products.forEach((product)=> {
                  if(product.price && product.quantity != 0){
                    var productTotal = parseInt(product.price)*parseInt(product.quantity);
                    if(product.extras_price!=undefined){
                         productTotal = productTotal+parseInt(product.extras_price); 
                    }
                    total_price = total_price + productTotal;
                  }
                })
              if(orderData.adminCommission!=undefined){
                  total_price = total_price-parseInt(orderData.adminCommission); 
              }
            })

             remaining = total_price - paid_price;
        });   
});
  return remaining; 
}


    $(document).ready(function(){
        $("#data-table_processing").show();
       database.collection('vendors').get().then( async function(snapshots){
  
          snapshots.docs.forEach((listval) => {
            var data = listval.data();
            $('#select_restaurant').append($("<option></option>")
                  .attr("value", data.id)
                  .text(data.title));
          })

      });
       $("#data-table_processing").hide();

       var payoutId = "<?php echo uniqid(); ?>";
    $(".save_restaurant_payout_btn").click( async function(){
      var vendorID = $("#select_restaurant").val();
      var remaining=await remainingPrice(vendorID);
      if(remaining >0){
          var amount = parseFloat($(".payout_amount").val());
          var note = $(".payout_note").val();
          var date = new Date(Date.now());
          if(vendorID != '' && $(".payout_amount").val() != ''){
            database.collection('payouts').doc(payoutId).set({'vendorID':vendorID,'amount':amount,'note':note,'id':payoutId,'paidDate':date}).then(function(){
              
                window.location.href = "<?php echo e(route('restaurantsPayouts')); ?>";
            })
          }else{
            alert("Please enter details");
          }
      }else{
          alert("Restaurant don't have sufficient credit for payout.");
      }
    
    

    })

  })


    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/restaurants_payouts/create.blade.php ENDPATH**/ ?>