<?php $__env->startSection('content'); ?>

<div class="page-wrapper">


    <div class="row page-titles">


        <div class="col-md-5 align-self-center">


            <h3 class="text-themecolor"><?php echo e(trans('lang.emergency')); ?></h3>


        </div>


        <div class="col-md-7 align-self-center">


            <ol class="breadcrumb">


                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>


                <li class="breadcrumb-item"><?php echo e(trans('lang.emergency')); ?></li>


                <li class="breadcrumb-item active"><?php echo e(trans('lang.emergency_list')); ?></li>


            </ol>


        </div>


        <div>


        </div>


    </div>


    <div class="container-fluid">


        <div class="row">


            <div class="col-12">


                <div class="card">

                    <div class="card-header">

                        <ul class="nav nav-tabs align-items-end card-header-tabs w-100">

                            <li class="nav-item">

                                <a class="nav-link active" href="<?php echo url()->current(); ?>"><i
                                            class="fa fa-list mr-2"></i><?php echo e(trans('lang.emergency_list')); ?></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link" href="<?php echo route('emergency.create'); ?>"><i
                                            class="fa fa-plus mr-2"></i><?php echo e(trans('lang.emergency_create')); ?></a>

                            </li>


                        </ul>

                    </div>

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                             style="display: none;"><?php echo e(trans('lang.processing')); ?>

                        </div>
                        
                        <div id="users-table_filter" class="pull-right"><label><?php echo e(trans('lang.search_by')); ?>

                                <select name="selected_search" id="selected_search" class="form-control input-sm">
                                    <option value="name"><?php echo e(trans('lang.emergency_name')); ?></option>
                                    <option value="number"><?php echo e(trans('lang.emergency_number')); ?></option>
                                </select>
                                <div class="form-group">
                                    <input type="search" id="search" class="search form-control"
                                           placeholder="Search" aria-controls="users-table">
                            	</label>&nbsp;<button onclick="searchtext();" class="btn btn-warning btn-flat">Search
                            	</button>&nbsp;<button onclick="searchclear();" class="btn btn-warning btn-flat">Clear
                            	</button>
                        	</div>
                    	</div>


                        <div class="table-responsive m-t-10">

                            <table id="example24"
                                   class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                   cellspacing="0" width="100%">


                                <thead>


                                <tr>


                                    <th><?php echo e(trans('lang.emergency_name')); ?></th>

                                    
                                    <th><?php echo e(trans('lang.emergency_number')); ?></th>


                                    <th><?php echo e(trans('lang.publish')); ?></th>


                                    <th><?php echo e(trans('lang.actions')); ?></th>


                                </tr>


                                </thead>


                                <tbody id="row_list">

                                </tbody>


                            </table>

                            <div class="data-table_paginate" id="data-table_paginate">

                                <nav aria-label="Page navigation example">

                                    <ul class="pagination justify-content-center">

                                        <li class="page-item ">

                                            <a class="page-link" href="javascript:void(0);"
                                               id="users_table_previous_btn" onclick="prev()" data-dt-idx="0"
                                               tabindex="0"><?php echo e(trans('lang.previous')); ?></a>

                                        </li>

                                        <li class="page-item">

                                            <a class="page-link" href="javascript:void(0);" id="users_table_next_btn"
                                               onclick="next()" data-dt-idx="2" tabindex="0"><?php echo e(trans('lang.next')); ?></a>

                                        </li>

                                    </ul>

                                </nav>

                            </div>


                        </div>

                    </div>


                </div>


            </div>


        </div>


    </div>


</div>


</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">


    var database = firebase.firestore();

    var offest = 1;

    var pagesize = 10;

    var end = null;

    var endarray = [];

    var start = null;

    var user_number = [];

    var refData = database.collection('emergency_number');

    var append_list = '';

    var placeholderImage = '';

    var placeholder = database.collection('settings').doc('placeHolderImage');


    placeholder.get().then(async function (snapshotsimage) {

        var placeholderImageData = snapshotsimage.data();

        placeholderImage = placeholderImageData.image;

    })


    $(document).ready(function () {


        var inx = parseInt(offest) * parseInt(pagesize);

        jQuery("#data-table_processing").show();


        append_list = document.getElementById('row_list');

        append_list.innerHTML = '';

        refData.orderBy('name').limit(pagesize).get().then(async function (snapshots) {

            html = '';

            html = await buildHTML(snapshots);

            jQuery("#data-table_processing").hide();

            if (html != '') {

                append_list.innerHTML = html;

                start = snapshots.docs[snapshots.docs.length - 1];

                endarray.push(snapshots.docs[0]);

                if (snapshots.docs.length < pagesize) {

                    jQuery("#data-table_paginate").hide();

                }

                disableClick();

            }else{
            	append_list.innerHTML = '<tr><td colspan="4"><?php echo e(trans("lang.no_results")); ?></td></tr>';
            	jQuery("#data-table_paginate").hide();
            }

        });


    })


    function buildHTML(snapshots) {


        if (snapshots.docs.length < pagesize) {

            jQuery("#data-table_paginate").hide();

        }

        var html = '';

        var number = [];

        var count = 0;

        snapshots.docs.forEach(async (listval) => {

            var listval = listval.data();

            var val = listval;

            val.id = listval.id;

            html = html + '<tr>';

            var id = val.id;

            var route1 = '<?php echo e(route("emergency.edit",":id")); ?>';

            route1 = route1.replace(':id', id);
            
            html = html + '<td>' + val.name + '</td>';

            html = html + '<td>' + val.number + '</td>';

            if (val.publish) {

                html = html + '<td><span class="badge badge-success">Yes</span></td>';

            } else {

                html = html + '<td><span class="badge badge-danger">No</span></td>';

            }

            html = html + '<td class="vendor-action-btn"><a href="' + route1 + '"><i class="fa fa-edit"></i></a><a id="' + val.id + '" name="vendor-delete" class="do_not_delete" href="javascript:void(0)"><i class="fa fa-trash"></i></a></td>';


            html = html + '</tr>';

            count = count + 1;

        });

        return html;

    }

    async function next() {

        if (start != undefined || start != null) {

            jQuery("#data-table_processing").hide();


            if (jQuery("#selected_search").val() == 'title' && jQuery("#search").val().trim() != '') {

                listener = refData.orderBy('name').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val() + '\uf8ff').startAfter(start).get();

            } else {

                listener = refData.startAfter(start).limit(pagesize).get();

            }

            listener.then(async (snapshots) => {


                html = '';

                html = await buildHTML(snapshots);

                console.log(snapshots);

                jQuery("#data-table_processing").hide();

                if (html != '') {

                    append_list.innerHTML = html;

                    start = snapshots.docs[snapshots.docs.length - 1];


                    if (endarray.indexOf(snapshots.docs[0]) != -1) {

                        endarray.splice(endarray.indexOf(snapshots.docs[0]), 1);

                    }

                    endarray.push(snapshots.docs[0]);

                }

            });

        }

    }


    async function prev() {

        if (endarray.length == 1) {

            return false;

        }

        end = endarray[endarray.length - 2];


        if (end != undefined || end != null) {

            jQuery("#data-table_processing").show();

            if (jQuery("#selected_search").val() == 'name' && jQuery("#search").val().trim() != '') {


                listener = refData.orderBy('title').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val() + '\uf8ff').startAt(end).get();

            } else {

                listener = refData.startAt(end).limit(pagesize).get();

            }


            listener.then(async (snapshots) => {

                html = '';

                html = await buildHTML(snapshots);

                jQuery("#data-table_processing").hide();

                if (html != '') {

                    append_list.innerHTML = html;

                    start = snapshots.docs[snapshots.docs.length - 1];

                    endarray.splice(endarray.indexOf(endarray[endarray.length - 1]), 1);


                    if (snapshots.docs.length < pagesize) {


                        jQuery("#users_table_previous_btn").hide();

                    }


                }

            });

        }

    }


    function searchtext() {


        jQuery("#data-table_processing").show();


        append_list.innerHTML = '';


        if (jQuery("#selected_search").val() == 'name' && jQuery("#search").val().trim() != '') {

            wherequery = refData.orderBy('name').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val() + '\uf8ff').get();

        } else if (jQuery("#selected_search").val() == 'number' && jQuery("#search").val().trim() != '') {

            wherequery = refData.orderBy('number').limit(pagesize).startAt(jQuery("#search").val()).endAt(jQuery("#search").val() + '\uf8ff').get();

        } else {

            wherequery = refData.limit(pagesize).get();

        }


        wherequery.then((snapshots) => {

            html = '';

            html = buildHTML(snapshots);

            jQuery("#data-table_processing").hide();

            if (html != '') {

                append_list.innerHTML = html;

                start = snapshots.docs[snapshots.docs.length - 1];

                endarray.push(snapshots.docs[0]);

                if (snapshots.docs.length < pagesize) {


                    jQuery("#data-table_paginate").hide();

                } else {


                    jQuery("#data-table_paginate").show();

                }

            }

        });


    }


    function searchclear() {

        jQuery("#search").val('');

        searchtext();

    }


    function disableClick() {

        var is_disable_delete = "<?php echo env('IS_DISABLE_DELETE'); ?>";

        if (is_disable_delete == 1) {

            jQuery("a.do_not_delete").removeAttr("name");

            jQuery("a.do_not_delete").attr("name", "alert_demo");

        }

    }

    $(document).on("click", "a[name='alert_demo']", function (e) {

        alert(doNotDeleteAlert);

    });


    $(document).on("click", "a[name='vendor-delete']", function (e) {
        var id = this.id;

        database.collection('emergency_number').doc(id).delete().then(function () {
            window.location.reload();
        });
    });


</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/emergency/index.blade.php ENDPATH**/ ?>