

<div class="card <?php echo e(Request::is('settings/app/*') ||
             Request::is('settings/app/social*') ||
             Request::is('settings/payment/*') ||
             Request::is('settings/currencies*') ||
             Request::is('settings/app/adminCommission*') ||
             Request::is('settings/restaurantNearBy*')
 ? '' : 'collapsed-card'); ?>">
    <div class="card-header">
        <h3 class="card-title"><?php echo e(trans('lang.app_setting_globals')); ?></h3>

        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-widget="collapse"><i class="fa <?php echo e(Request::is('settings/app/*') ||
             Request::is('settings/payment*') ||
             Request::is('settings/currencies*') ||
             Request::is('settings/restaurantNearBy*')
             ? 'fa-minus' : 'fa-plus'); ?>"></i>
            </button>
        </div>
    </div>
    <div class="card-body p-0">
        <ul class="nav nav-pills flex-column">
            <li class="nav-item">
                <a href="<?php echo url('settings/app/globals'); ?>" class="nav-link <?php echo e(Request::is('settings/app/globals*') ? 'selected' : ''); ?>">
                    <i class="fa fa-cog"></i> <?php echo e(trans('lang.app_setting_globals')); ?>

                </a>
            </li>

            <li class="nav-item">
                <a href="<?php echo url('settings/app/social'); ?>" class="nav-link <?php echo e(Request::is('settings/app/social*') ? 'selected' : ''); ?>">
                    <i class="fa fa-globe"></i> <?php echo e(trans('lang.app_setting_social')); ?>

                </a>
            </li>

            <li class="nav-item">
                <a href="<?php echo url('settings/payment/payment'); ?>" class="nav-link <?php echo e(Request::is('settings/payment*') ? 'selected' : ''); ?>">
                    <i class="fa fa-credit-card"></i> <?php echo e(trans('lang.app_setting_payment')); ?>

                </a>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('currencies.index')): ?>
                <li class="nav-item">
                    <a href="<?php echo route('currencies.index'); ?>" class="nav-link <?php echo e(Request::is('settings/currencies*') ? 'selected' : ''); ?>" ><i class="nav-icon fa fa-dollar ml-1"></i> <?php echo e(trans('lang.currency_plural')); ?></a>
                </li>
            <?php endif; ?>

            <li class="nav-item">
                <a href="<?php echo url('settings/app/notifications'); ?>" class="nav-link <?php echo e(Request::is('settings/app/notifications*') || Request::is('notificationTypes*') ? 'selected' : ''); ?>">
                    <i class="fa fa-bell"></i> <?php echo e(trans('lang.app_setting_notifications')); ?>

                </a>
            </li>

            <li class="nav-item">
                <a href="<?php echo url('settings/app/adminCommission'); ?>" class="nav-link <?php echo e(Request::is('settings/app/adminCommission*') || Request::is('adminCommission*') ? 'selected' : ''); ?>">
                    <i class="fa fa-percent"></i> Admin Commission
                </a>
            </li>

            <li class="nav-item">
                <a href="<?php echo url('settings/restaurantNearBy'); ?>" class="nav-link <?php echo e(Request::is('settings/restaurantNearBy*') || Request::is('restaurantNearBy*') ? 'selected' : ''); ?>">
                    <i class="fa fa-road"></i> Restaurant Nearby Radios
                </a>
            </li>

        </ul>
    </div>
</div>


<div class="card <?php echo e(Request::is('settings/mobile*') ? '' : 'collapsed-card'); ?>">
    <div class="card-header">
        <h3 class="card-title"><?php echo e(trans('lang.mobile_menu')); ?></h3>

        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-widget="collapse"><i class="fa <?php echo e(Request::is('settings/mobile*') ? 'fa-minus' : 'fa-plus'); ?>"></i>
            </button>
        </div>
    </div>
    <div class="card-body p-0">
        <ul class="nav nav-pills flex-column">
            <li class="nav-item">
                <a href="<?php echo url('settings/mobile/globals'); ?>" class="nav-link <?php echo e(Request::is('settings/mobile/globals*') ? 'selected' : ''); ?>">
                    <i class="fa fa-inbox"></i> <?php echo e(trans('lang.mobile_globals')); ?>

                </a>
            </li>

        </ul>
    </div>
</div>
<?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/layouts/settings/menu.blade.php ENDPATH**/ ?>