<?php
error_reporting(E_ALL ^ E_NOTICE);
?>

<?php $__env->startSection('content'); ?>

<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.video_size')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.video_size')); ?></li>
            </ol>
        </div>
        <div>
        </div>
    </div>

    <div class="col-md-12 align-self-center">

        <div class="card-body">
            <div id="data-table_processing" class="dataTables_processing panel panel-default d-none">
                <?php echo e(trans('lang.processing')); ?>

            </div>
            <div id="data-saving" class="dataTables_processing panel panel-default d-none"><?php echo e(trans('lang.saving')); ?>

            </div>
            <div class="error_top"></div>

            <div class="row vendor_payout_create">
                <div class="vendor_payout_create-inner">
                    <fieldset>
                        <legend><?php echo e(trans('lang.video_size')); ?></legend>

                        <div class="form-group row width-100">
                            <label class="col-4 control-label"><?php echo e(trans('lang.video_size')); ?></label>
                            <div class="col-7">
                                <div class="control-inner">
                                    <input type="number" class="form-control video_size">
                                    <span><?php echo e(trans('lang.mb')); ?></span>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group col-12 text-center btm-btn">
        <button type="button" class="btn btn-primary  create_user_btn"><i
                class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?>

        </button>
        <a href="<?php echo route('dashboard'); ?>" class="btn btn-default"><i
                class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>

    var database = firebase.firestore();
    var videoSize = database.collection('settings').doc('videoSize');

    $(document).ready(function () {
        $('#data-table_processing').removeClass('d-none');
        getVideoLength();
    });

    function getVideoLength(){
        videoSize.get().then(async function (snapshots) {
            var video = snapshots.data();

            if (video == undefined) {
                database.collection('settings').doc('videoSize').set({});
            }

            try {
                $('.video_size').val(video.videoSize);

            } catch (error) {

            }
            $('#data-table_processing').addClass('d-none');
        });
    }

    $('.create_user_btn').click(function () {
        var video_size = $('.video_size').val();

        if (video_size == "") {
            $(".error_top").show();
            $(".error_top").html('');
            $(".error_top").append("<p><?php echo e(trans('lang.video_size_error')); ?></p>");
            window.scrollTo(0, 0);
        } else if(video_size > 10){
            $(".error_top").show();
            $(".error_top").html('');
            $(".error_top").append("<p><?php echo e(trans('lang.video_size_limit')); ?></p>");
            window.scrollTo(0, 0);
        }else if(video_size <= 0){
            $(".error_top").show();
            $(".error_top").html('');
            $(".error_top").append("<p><?php echo e(trans('lang.video_size_valid')); ?></p>");
            window.scrollTo(0, 0);
        }else {
            $(".error_top").hide();
            $(".error_top").html('');
            $('#data-saving').removeClass('d-none');
            var id = "<?php echo uniqid(); ?>";
            database.collection('settings').doc('videoSize').set({
                'id': id,
                'videoSize': video_size,
                'videoSizeType': "MB",
            }).then(function (result) {
                $('#data-saving').addClass('d-none');
                getVideoLength();
            })
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/settings/videoSize/index.blade.php ENDPATH**/ ?>