<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
        <div class="card">
            <ul class="nav nav-tabs">
               <li class="nav-item">
                    <a class="nav-link active stripe_active_label" href="<?php echo url('settings/payment/payment'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_stripe')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link cod_active_label" href="<?php echo url('settings/payment/cod'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_cod_short')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link apple_pay_active_label" href="<?php echo url('settings/payment/applepay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_apple_pay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                  <li class="nav-item">
                    <a class="nav-link razorpay_active_label" href="<?php echo url('settings/payment/razorpay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_razorpay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
            </ul>

            <div class="card-body">
      	        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>

                <div class="form-check">
                    <input type="checkbox" class=" ml-2 form-check-inline enable_stripe" id="enable_stripe">
                    <label class="col-3 control-label" for="enable_stripe"><?php echo e(trans('lang.app_setting_enable_stripe')); ?></label>
                    <span class="ml-2"><?php echo trans('lang.app_setting_enable_stripe_help'); ?></span>
                </div>  
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_stripe_key')); ?></label>
                    <input type="text" class=" col-7 form-control stripe_key">
                    <div class="form-text text-muted">
                        <?php echo trans('lang.app_setting_stripe_key_help'); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_stripe_secret')); ?></label>
                    <input type="text" class=" col-7 form-control stripe_secret">
                    <div class="form-text text-muted">
                        <?php echo trans('lang.app_setting_stripe_secret_help'); ?>

                    </div>
                </div>
                <div class="form-group col-12 text-right">
                    <button type="button" class="btn btn-primary save_stripe_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                </div>
            </div>
        </div>   
    </div> 


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
        var database = firebase.firestore();
        var ref = database.collection('settings').doc('stripeSettings');
        var codData = database.collection('settings').doc('CODSettings');
        var applePayData = database.collection('settings').doc('applePay');
        var razorpayData = database.collection('settings').doc('razorpaySettings');


$(document).ready(function(){
  jQuery("#data-table_processing").show();
  ref.get().then( async function(snapshots){
    var stripe = snapshots.data();

    if(stripe.isEnabled){
      $(".enable_stripe").prop('checked',true);
        jQuery(".stripe_active_label span").addClass('badge-success');
        jQuery(".stripe_active_label span").text('Active');
    }

    $(".stripe_key").val(stripe.stripeKey);
    $(".stripe_secret").val(stripe.stripeSecret);

    codData.get().then(  async function(codSnapshots){
        var cod = codSnapshots.data();
        if(cod.isEnabled){
            jQuery(".cod_active_label span").addClass('badge-success');
            jQuery(".cod_active_label span").text('Active');
        }

    })

    applePayData.get().then(  async function(applePaySnapshots){
        var applePay = applePaySnapshots.data();
        if(applePay.isEnabled){
            jQuery(".apple_pay_active_label span").addClass('badge-success');
            jQuery(".apple_pay_active_label span").text('Active');
        }
    })

     razorpayData.get().then(  async function(razorpaySnapshots){
        var razorPay = razorpaySnapshots.data();
        if(razorPay.isEnabled){
            jQuery(".razorpay_active_label span").addClass('badge-success');
            jQuery(".razorpay_active_label span").text('Active');
        }
    })
      
  jQuery("#data-table_processing").hide();
    /* console.log($(".note-editable").html()); */  
  })

  $(".save_stripe_btn").click(function(){
     
        var stripeKey = $(".stripe_key").val();
        var stripeSecret = $(".stripe_secret").val();
        var isStripeEnabled = $(".enable_stripe").is(":checked");
        database.collection('settings').doc("stripeSettings").update({'isEnabled':isStripeEnabled,'stripeKey':stripeKey,'stripeSecret':stripeSecret}).then(function(result) {

                window.location.href = '<?php echo e(url("settings/payment/stripe")); ?>';
                    
                 });
       
            })

})

</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/settings/app/stripe.blade.php ENDPATH**/ ?>