<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.restaurants_payout_plural')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <?php if($id !=''){ ?>
                	<li class="breadcrumb-item"><a href="<?php echo e(route('restaurants.payout', ['id' => $id])); ?>" ><?php echo e(trans('lang.restaurants_payout_table')); ?></a></li>
            	<?php } ?>
                <li class="breadcrumb-item"><?php echo e(trans('lang.restaurants_payout_create')); ?></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	   <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
      	   <div class="error_top"></div>
              <div class="row restaurant_payout_create">
                <div class="restaurant_payout_create-inner">
                  <fieldset>
                    <legend><?php echo e(trans('lang.restaurants_payout_create')); ?></legend>
                    <?php if($id ==''){ ?>
                      <div class="form-group row width-100">
                        <label class="col-3 control-label"><?php echo e(trans('lang.restaurants_payout_restaurant_id')); ?></label>
                        <div class="col-7">
                          <select id="select_restaurant" class="form-control">
                              <option value=""><?php echo e(trans('lang.select_restaurant')); ?></option>
                          </select>
                        <div class="form-text text-muted">
                          <?php echo e(trans("lang.restaurants_payout_restaurant_id_help")); ?>

                        </div>
                      </div>
                    </div>
                  <?php }?> 
                      <div class="form-group row width-100">
                        <label class="col-3 control-label"><?php echo e(trans('lang.restaurants_payout_amount')); ?></label>
                        <div class="col-7">
                          <input type="number" class="form-control payout_amount">          
                          <div class="form-text text-muted">
                            <?php echo e(trans("lang.restaurants_payout_amount_placeholder")); ?>

                          </div>
                        </div>
                      </div>
                       

                      <div class="form-group row width-100">
                        <label class="col-3 control-label"><?php echo e(trans('lang.restaurants_payout_note')); ?></label>
                        <div class="col-7">
                          <textarea type="text" rows="8" class="form-control payout_note"></textarea>
                        </div>
                      </div>

                </fieldset>
              </div>     
            </div>
         </div>

          <div class="form-group col-12 text-center btm-btn">
              <button type="button" class="btn btn-primary save_restaurant_payout_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
              <?php if($id != ''){?>           
                  <a href="<?php echo e(route('restaurants.payout',$id)); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
              <?php }else{ ?>
                 <a href="<?php echo route('restaurantsPayouts'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
              <?php } ?>

              <!-- <a href="<?php echo route('restaurantsPayouts'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a> -->
          </div>
        </div>
      </div>
    </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
      
    var database = firebase.firestore();

  async function remainingPrice(vendorID){
  var paid_price = 0;
  var total_price = 0;
  var remaining = 0;
  var adminCommission=0;
  var commission = 0;
  await database.collection('payouts').where('vendorID','==',vendorID).get().then( async function(payoutSnapshots){        
       payoutSnapshots.docs.forEach((payout)=>{
          var payoutData = payout.data();
          paid_price = parseFloat(paid_price) + parseFloat(payoutData.amount);
        })

        await database.collection('restaurant_orders').where('vendor.id','==',vendorID).where("status","in",["Order Completed"]).get().then( async function(orderSnapshots){

            orderSnapshots.docs.forEach((order)=>{
              var orderData = order.data();
              var productTotalmain=0;
              orderData.products.forEach((product)=> {
                  if(product.price && product.quantity != 0){
                    var extras_price=0;
                    if(product.extras_price!=undefined){
                        extras_price=product.extras_price;
                    }

                    var productTotal = (parseInt(product.price)*parseInt(product.quantity))+extras_price;
                    if(product.extras_price!=undefined){
                         productTotal = productTotal+parseInt(product.extras_price); 
                    }
                    total_price = total_price + productTotal;
                    productTotalmain=productTotalmain+productTotal;
                  }
                })
              /*if(orderData.adminCommission!=undefined){
                  total_price = total_price-parseInt(orderData.adminCommission); 
              }*/

              if(orderData.adminCommission!=undefined && orderData.adminCommissionType!=undefined){
                    if(orderData.adminCommissionType=="Percent"){
                        commission = (productTotalmain*parseFloat(orderData.adminCommission))/100;
                        
                    }else{
                        commission = parseFloat(orderData.adminCommission);
                    }
              }else if(orderData.adminCommission!=undefined){
                      commission = parseFloat(orderData.adminCommission);
              }

            })

            if(adminCommission!=undefined){
                  total_price = total_price-parseInt(commission); 
            }

             remaining = total_price - paid_price;
        });   
});
  return remaining; 
}


    $(document).ready(function(){
        $("#data-table_processing").show();
       database.collection('vendors').get().then( async function(snapshots){
  
          snapshots.docs.forEach((listval) => {
            var data = listval.data();
            $('#select_restaurant').append($("<option></option>")
                  .attr("value", data.id)
                  .text(data.title));
          })

      });
       $("#data-table_processing").hide();

       var payoutId = "<?php echo uniqid(); ?>";
    $(".save_restaurant_payout_btn").click( async function(){
      <?php if($id ==''){ ?>
        var vendorID = $("#select_restaurant").val();
      <?php }else{?>
        var vendorID = "<?php echo $id; ?>";
      <?php } ?>

      
      var remaining=await remainingPrice(vendorID);
      console.log(remaining);
      console.log("remaining");
      if(remaining >0){
          var amount = parseFloat($(".payout_amount").val());
          var note = $(".payout_note").val();
          var date = new Date(Date.now());
          if(vendorID != '' && $(".payout_amount").val() != ''){
            database.collection('payouts').doc(payoutId).set({'vendorID':vendorID,'amount':amount,'note':note,'id':payoutId,'paidDate':date}).then(function(){
                 <?php if($id ==''){ ?>

                    window.location.href = "<?php echo e(route('restaurants.payout',$id)); ?>";
                 <?php }else{?>

                    window.location.href = '<?php echo e(route("restaurantsPayouts")); ?>';
                 <?php } ?>


                //window.location.href = "<?php echo e(route('restaurantsPayouts')); ?>";
            })
          }else{
          	$(".error_top").show();
          	$(".error_top").html("");
            $(window).scrollTop(0);
          	$(".error_top").append("<p><?php echo e(trans('lang.please_enter_details')); ?></p>");
            // alert("Please enter details");
          }
      }else{
          //alert("Restaurant don't have sufficient credit for payout.");
          	$(".error_top").show();
            $(window).scrollTop(0);
          	$(".error_top").html("");
          	$(".error_top").append("<p><?php echo e(trans('lang.restaurant_insufficient_payment_error')); ?></p>");
      }
    
    

    })

  })


    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/resources/views/restaurants_payouts/create.blade.php ENDPATH**/ ?>