<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-none">
	<div class="bg-primary p-3 d-flex align-items-center">
		<a class="toggle togglew toggle-2" href="#"><span></span></a>
		<h4 class="font-weight-bold m-0 text-white">My Order</h4>
	</div>
</div>
<section class="py-4 osahan-main-body">
	<div class="container">
		<div class="row">
			<div class="col-md-3">
				<ul class="nav nav-tabsa custom-tabsa border-0 flex-column bg-white rounded overflow-hidden shadow-sm p-2 c-t-order" id="myTab" role="tablist">
					<li class="nav-item" role="presentation">
						<a class="nav-link border-0 text-dark py-3" href="<?php echo e(url('my_order')); ?>"> <i class="feather-check mr-2 text-success mb-0"></i> Completed</a>
					</li>
					<li class="nav-item border-top" role="presentation">
						<a class="nav-link border-0 text-dark py-3" href="<?php echo e(url('my_order')); ?>"> <i class="feather-clock mr-2 text-warning mb-0"></i> On Progress</a>
					</li>
					<li class="nav-item border-top" role="presentation">
						<a class="nav-link border-0 text-dark py-3 active" href="<?php echo e(url('my_order')); ?>"> <i class="feather-x-circle mr-2 text-danger mb-0"></i> Canceled</a>
					</li>
				</ul>
			</div>
			<div class="col-md-9">

				<section class="bg-white osahan-main-body rounded shadow-sm overflow-hidden">
					<div class="container p-0">
						<div class="row">
							<div class="col-lg-12">
									
									<div class="p-3 status-order bg-white border-bottom d-flex align-items-center">
										<div class="clear-both">
											<h6 class="font-weight-bold">Order Date</h6>
											<p class="m-0 small" id="order-date"></p>
										</div>
										<div class="clear-both ml-auto">
											<a href="#" class="text-primary ml-auto text-decoration-none">Review</a>	
										</div>
									</div>
									
									<div class="p-3 border-bottom bg-white">
										<h6 class="font-weight-bold">Order Number</h6>
										<p class="m-0 small" id="order-number"></p>
									</div>
									
									<div class="p-3 border-bottom">
										<h6 class="font-weight-bold">Order Status</h6>
										<p class="m-0 small" id="order-status"></p>
									</div>
									
									<div class="p-3 border-bottom bg-white">
										<h6 class="font-weight-bold">Order Address</h6>
										<p class="m-0 small" id="order-addreess"></p>
									</div>
									
									<div class="p-3 border-bottom">
										<h6 class="font-weight-bold">Order Items</h6>	
										<div id="order-items"></div>
									</div>
									
									<div class="p-3 border-bottom">
										<div class="d-flex align-items-center mb-2">
											<h6 class="font-weight-bold mb-1">Order Subtotal</h6>
											<h6 class="font-weight-bold ml-auto mb-1" id="order-subtotal"></h6>
										</div>
									</div>
									
									<div class="p-3 border-bottom">
										<div class="d-flex align-items-center mb-2">
											<h6 class="font-weight-bold mb-1">Order Shipping</h6>
											<h6 class="font-weight-bold ml-auto mb-1" id="order-shipping"></h6>
										</div>
									</div>
									
									<div class="p-3 border-bottom">
										<div class="d-flex align-items-center mb-2">
											<h6 class="font-weight-bold mb-1">Order Discount</h6>
											<h6 class="font-weight-bold ml-auto mb-1" id="order-discount"></h6>
										</div>
									</div>

									<div class="p-3 bg-white">
										<div class="d-flex align-items-center mb-2">
											<h6 class="font-weight-bold mb-1">Order Total</h6>
											<h6 class="font-weight-bold ml-auto mb-1" id="order-total"></h6>
										</div>
										<p class="m-0 small text-muted">
											You can check your order detail here,
											<br>
											Thank you for order.
										</p>
									</div>
									
									<div class="p-3 border-bottom">
										<p class="font-weight-bold small mb-1">
											Courier
										</p>
										<img alt="#" src="img/logo_web.png" class="img-fluid sc-osahan-logo mr-2"><span class="small text-primary font-weight-bold">Grocery Courier </span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
			</div>
		</div>
	</div>
</section>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">
	
	console.log(user_uuid);
	
	var orderId =   "<?php echo $_GET['id']; ?>";
	
	var append_categories = '';
	
	var completedorsersref= database.collection('restaurant_orders').where('id',"==",orderId);

	$(document).ready(function() {
		getOrderDetails();
	});

	async function getOrderDetails(){

		completedorsersref.get().then( async function(completedorderSnapshots){
		
			var orderDetails = completedorderSnapshots.docs[0].data();
			console.log(orderDetails);
			
			var orderDate = orderDetails.createdAt.toDate().toDateString();
			var time = orderDetails.createdAt.toDate().toLocaleTimeString('en-US');
			$("#order-date").html(orderDate+' '+time);
			
			var order_address = orderDetails.address.line1+' '+orderDetails.address.line2 +', '+orderDetails.address.city +', '+orderDetails.address.country;
			$("#order-addreess").html(order_address);
		
			var order_items = order_status = '';
			var order_subtotal = order_shipping = order_total = 0;

			order_items +='<tr>';
				order_items +='<th></th>';
				order_items +='<th class="prod-name">Item Name</th>';
				order_items +='<th class="qunt">Quantity</th>';
				order_items +='<th class="price text-right">Price</th>';
			order_items +='</tr>';
			
			for(let i = 0; i < orderDetails.products.length; i++) {
				order_subtotal = order_subtotal + orderDetails.products[i]['price'] * orderDetails.products[i]['quantity'];
				/*order_items += '<div class="p-3">';
				   order_items += '<div class="d-flex pb-3">';
				      order_items += '<div class="text-muted mr-3 photo"><img alt="#" src="'+orderDetails.products[i]['photo']+'" class="img-fluid order_img rounded"></div>';
				      order_items += '<div class="item-detail">';
				         order_items += '<p class="mb-0 font-weight-bold name">Name: '+orderDetails.products[i]['name']+'</p>';
				         order_items += '<p class="mb-0 qty">Quantity: '+orderDetails.products[i]['quantity']+'</p>';
				         order_items += '<p class="price">Price: $'+orderDetails.products[i]['quantity']*orderDetails.products[i]['price']+'</p>';
				      order_items += '</div>';
				   order_items += '</div>';
				order_items += '</div>';*/

				order_items += '<tr>';
			      	order_items += '<td class="ord-photo"><img alt="#" src="'+orderDetails.products[i]['photo']+'" class="img-fluid order_img rounded"></td>';
			      	order_items += '<td class="prod-name">'+orderDetails.products[i]['name']+'</td>';
			      	order_items += '<td class="qunt">'+orderDetails.products[i]['quantity']+'</td>';
			      	order_items += '<td class="price text-right">$'+orderDetails.products[i]['quantity']*orderDetails.products[i]['price']+'</td>';
				order_items += '</tr>';
			}
			order_number = orderDetails['id'];
			order_status = orderDetails['status'];
			order_discount = orderDetails['discount'];
			order_subtotal = order_subtotal + order_shipping;
			order_total = order_subtotal - order_discount;
			
			$("#order-number").html(order_number);
			$("#order-status").html(order_status);
			$("#order-items").html('<table class="order-list">'+order_items+'</table>');
			$("#order-subtotal").html('$'+order_subtotal);
			$("#order-shipping").html('$'+order_shipping);
			$("#order-discount").html('$'+order_discount);
			$("#order-total").append('$'+order_total);
		})
	}

</script><?php /**PATH /home/foodie/public_html/website/resources/views/my_order/cancelled_order.blade.php ENDPATH**/ ?>