import 'package:cached_network_image/cached_network_image.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:emartconsumer/AppGlobal.dart';
import 'package:emartconsumer/constants.dart';
import 'package:emartconsumer/model/ProductModel.dart';
import 'package:emartconsumer/model/VendorCategoryModel.dart';
import 'package:emartconsumer/model/VendorModel.dart';
import 'package:emartconsumer/services/FirebaseHelper.dart';
import 'package:emartconsumer/services/helper.dart';
import 'package:emartconsumer/ui/productDetailsScreen/ProductDetailsScreen.dart';
import 'package:flutter/material.dart';

class ViewAllCategoryProductScreen extends StatefulWidget {
  VendorCategoryModel? vendorCategoryModel;
   ViewAllCategoryProductScreen({Key? key,this.vendorCategoryModel}) : super(key: key);

  @override
  State<ViewAllCategoryProductScreen> createState() => _ViewAllCategoryProductScreenState();
}

class _ViewAllCategoryProductScreenState extends State<ViewAllCategoryProductScreen> {
  List<ProductModel> productList = [];
  bool showLoader = true;
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    getProductByCategoryId();
  }

  getProductByCategoryId() async {
    await FireStoreUtils.getProductListByCategoryId(widget.vendorCategoryModel!.id.toString()).then((value) {

      setState(() {
        productList = value;
        showLoader = false;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppGlobal.buildAppBar(context, widget.vendorCategoryModel!.title.toString()),
      body: Container(
        width: MediaQuery.of(context).size.width,
        height: MediaQuery.of(context).size.height,
        margin: const EdgeInsets.fromLTRB(10, 0, 0, 10),
        child: showLoader
            ? Center(
                child: CircularProgressIndicator.adaptive(
                  valueColor: AlwaysStoppedAnimation(Color(COLOR_PRIMARY)),
                ),
              )
            : productList.isEmpty
                ? showEmptyState("No Item found".tr())
                : ListView.builder(
                    shrinkWrap: true,
                    scrollDirection: Axis.vertical,
                    physics: const BouncingScrollPhysics(),
                    itemCount: productList.length,
                    itemBuilder: (context, index) {
                      return buildVendorItemData(context, productList[index]);
                    }),
      ),
    );
  }

  Widget buildVendorItemData(BuildContext context, ProductModel productModel) {
    return GestureDetector(
      onTap: () async {
        VendorModel? vendorModel = await FireStoreUtils.getVendor(productModel.vendorID);
        if (vendorModel != null) {
          push(
            context,
            ProductDetailsScreen(
              vendorModel: vendorModel,
              productModel: productModel,
            ),
          );
        }
      },
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
            border: Border.all(color: Colors.grey.shade100, width: 1),
            boxShadow: [
              isDarkMode(context)
                  ? const BoxShadow()
                  :  BoxShadow(
                color: Colors.grey.withOpacity(0.5),
                blurRadius: 5.0,
              ),
            ],
          ),
          width: MediaQuery.of(context).size.width * 0.8,
          padding: const EdgeInsets.all(8),
          child: Row(
            children: [
              ClipRRect(
                borderRadius: BorderRadius.circular(10),
                child: CachedNetworkImage(
                  imageUrl: productModel.photo,
                  height: 80,
                  width: 80,
                  imageBuilder: (context, imageProvider) => Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      image: DecorationImage(image: imageProvider, fit: BoxFit.cover),
                    ),
                  ),
                  placeholder: (context, url) => Center(
                      child: CircularProgressIndicator.adaptive(
                    valueColor: AlwaysStoppedAnimation(Color(COLOR_PRIMARY)),
                  )),
                  errorWidget: (context, url, error) => ClipRRect(
                      borderRadius: BorderRadius.circular(10),
                      child: Image.network(
                        AppGlobal.placeHolderImage!,
                        fit: BoxFit.cover,
                        width: MediaQuery.of(context).size.width,
                        height: MediaQuery.of(context).size.height,
                      )),
                  fit: BoxFit.cover,
                ),
              ),
              const SizedBox(
                width: 10,
              ),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      productModel.name,
                      style: const TextStyle(
                        fontFamily: "Poppinsm",
                        fontSize: 18,
                        color: Color(0xff000000),
                      ),
                      maxLines: 1,
                    ),
                    productModel.disPrice == "" || productModel.disPrice == "0"
                        ? Text(
                            symbol + double.parse(productModel.price).toStringAsFixed(decimal),
                            style: TextStyle(fontSize: 16, fontFamily: "Poppinsm", letterSpacing: 0.5, color: Color(COLOR_PRIMARY)),
                          )
                        : Row(
                            children: [
                              Text(
                                "$symbol${double.parse(productModel.disPrice.toString()).toStringAsFixed(decimal)}",
                                style: TextStyle(
                                  fontFamily: "Poppinsm",
                                  fontSize: 16,
                                  fontWeight: FontWeight.bold,
                                  color: Color(COLOR_PRIMARY),
                                ),
                              ),
                              const SizedBox(
                                width: 10,
                              ),
                              Text(
                                '$symbol${double.parse(productModel.price).toStringAsFixed(decimal)}',
                                style: const TextStyle(
                                    fontFamily: "Poppinsm",
                                    fontWeight: FontWeight.bold,
                                    color: Colors.grey,
                                    decoration: TextDecoration.lineThrough),
                              ),
                            ],
                          ),
                    const SizedBox(
                      height: 5,
                    ),
                    Container(
                      decoration: BoxDecoration(
                        color: Colors.green,
                        borderRadius: BorderRadius.circular(5),
                      ),
                      child: Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 5, vertical: 2),
                        child: Row(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Text(
                                productModel.reviewsCount != 0
                                    ? (productModel.reviewsSum / productModel.reviewsCount).toStringAsFixed(1)
                                    : 0.toString(),
                                style: const TextStyle(
                                  fontFamily: "Poppinsm",
                                  letterSpacing: 0.5,
                                  fontSize: 12,
                                  color: Colors.white,
                                )),
                            const SizedBox(width: 3),
                            const Icon(
                              Icons.star,
                              size: 16,
                              color: Colors.white,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    );
  }
}
